<?php
/**
 * Single Product Price, including microdata for SEO
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $post, $product;

if( $product->get_price() === '') return;
?>
<div itemprop="offers" itemscope itemtype="http://schema.org/Offer">

    <?php if ( $product->get_price_html() != "" ) :

        $html = $product->get_price_html();
        if ( strpos( $html, '<ins><span class="amount">' ) ) {
            $html = str_replace( '<ins><span class="amount">', '<ins><span class="amount" itemprop="price">', $html );
        }
        else {
            $html = str_replace( '<span class="amount">', '<span class="amount" itemprop="price">', $html );
        }

        ?>

        <p class="price">
            <?php echo $html; ?>
        </p>

        <meta itemprop="priceCurrency" content="<?php echo get_woocommerce_currency(); ?>" />

    <?php endif ?>

	<link itemprop="availability" href="http://schema.org/<?php echo $product->is_in_stock() ? 'InStock' : 'OutOfStock'; ?>" />

</div>

<!-- <div class="new-prices" style="
    display: block;
    float: none;
    clear: both;
">
  <select name="currencySelect" id="currencySelect">
    <option value="gbp"> GBP - £</option>
    <option value="eur"> EUR - €</option>
    <option value="usd"> USD - $</option>
  </select>
</div>

 -->

<script type="text/javascript">
    // jQuery( document ).ready(function() {
    //     var price = jQuery(".price .amount").html();
    //     price = price.replace('£,','');
    //     console.log(price);

    //     var gbp = price;
    //     var eur = price*1.41;
    //     var usd = price*1.56;

    //     // var eur = price*"<?php echo $eur; ?>";
    //     // var usd = price*"<?php echo $usd; ?>";


    //     jQuery('#currencySelect').on('change', function() {

    //         var curr = jQuery(this).val();

    //         if (curr=='gbp') {
    //             jQuery(".price .amount").html('£'+gbp);
    //         };

    //         if (curr=='eur') {
    //             eur = Math.round(eur * 100) / 100;
    //             jQuery(".price .amount").html('€'+eur);
    //         };

    //         if (curr=='usd') {
    //             usd = Math.round(usd * 100) / 100;
    //             jQuery(".price .amount").html('$'+usd);
    //         };


    //     });
    // });
</script>