<?php
/**
 * Shop breadcrumb
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.0
 * @see         woocommerce_breadcrumb()
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $post, $wp_query, $author;

$prepend      = '';
$permalinks   = get_option( 'woocommerce_permalinks' );
$shop_page_id = wc_get_page_id( 'shop' );
$shop_page    = get_post( $shop_page_id );
$delimiter = ' &raquo; ';
$wrap_before = '<div id="breadcrumb">';
$wrap_after = '</div>';

// If permalinks contain the shop page in the URI prepend the breadcrumb with shop
if ( $shop_page_id && strstr( $permalinks['product_base'], '/' . $shop_page->post_name ) && get_option( 'page_on_front' ) !== $shop_page_id ) {
    $prepend = $before . '<a href="' . get_permalink( $shop_page ) . '">' . $shop_page->post_title . '</a> ' . $after . $delimiter;
}

if ( ( ! is_front_page() && ! ( is_post_type_archive() && get_option( 'page_on_front' ) == wc_get_page_id( 'shop' ) ) ) || is_paged() ) {

    echo $wrap_before;

    if ( ! empty( $home ) ) {
        echo $before . '<a class="home" href="' . apply_filters( 'woocommerce_breadcrumb_home_url', home_url() ) . '">' . $home . '</a>' . $after . $delimiter;
    }

    if ( is_home() ) {

        echo $before . single_post_title('', false) . $after;

    } elseif ( is_category() ) {

        $cat_obj = $wp_query->get_queried_object();
        $this_category = get_category( $cat_obj->term_id );

        if ( 0 != $this_category->parent ) {
            $parent_category = get_category( $this_category->parent );
            if ( ( $parents = get_category_parents( $parent_category, TRUE, $after . $delimiter . $before ) ) && ! is_wp_error( $parents ) ) {
                echo $before . rtrim( $parents, $after . $delimiter . $before ) . $after . $delimiter;
            }
        }

        echo $before . single_cat_title( '', false ) . $after;

    } elseif ( is_tax('product_cat') ) {

        echo $prepend;

        $current_term = $wp_query->get_queried_object();

        $ancestors = array_reverse( get_ancestors( $current_term->term_id, 'product_cat' ) );

        foreach ( $ancestors as $ancestor ) {
            $ancestor = get_term( $ancestor, 'product_cat' );

            echo $before .  '<a href="' . get_term_link( $ancestor ) . '">' . esc_html( $ancestor->name ) . '</a>' . $after . $delimiter;
        }

        echo $before . esc_html( $current_term->name ) . $after;

    } elseif ( is_tax('product_tag') ) {

        $queried_object = $wp_query->get_queried_object();
        echo $prepend . $before . __( 'Products tagged &ldquo;', 'yiw' ) . $queried_object->name . '&rdquo;' . $after;

    } elseif ( is_day() ) {

        echo $before . '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a>' . $after . $delimiter;
        echo $before . '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a>' . $after . $delimiter;
        echo $before . get_the_time('d') . $after;

    } elseif ( is_month() ) {

        echo $before . '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a>' . $after . $delimiter;
        echo $before . get_the_time('F') . $after;

    } elseif ( is_year() ) {

        echo $before . get_the_time('Y') . $after;

    } elseif ( is_post_type_archive('product') && get_option('page_on_front') !== $shop_page_id ) {

        $_name = wc_get_page_id( 'shop' ) ? get_the_title( wc_get_page_id( 'shop' ) ) : '';

        if ( ! $_name ) {
            $product_post_type = get_post_type_object( 'product' );
            $_name = $product_post_type->labels->singular_name;
        }

        if ( is_search() ) {

            echo $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $delimiter . __( 'Search results for &ldquo;', 'yiw' ) . get_search_query() . '&rdquo;' . $after;

        } elseif ( is_paged() ) {

            echo $before . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $after;

        } else {

            echo $before . $_name . $after;

        }

    } elseif ( is_single() && ! is_attachment() ) {

    if ( 'product' == get_post_type() ) {

            echo $prepend;

            if ( $terms = wp_get_post_terms( $post->ID, 'product_cat', array( 'orderby' => 'parent', 'order' => 'DESC' ) ) ) {
                $main_term = $terms[0];
                $ancestors = get_ancestors( $main_term->term_id, 'product_cat' );
                $ancestors = array_reverse( $ancestors );

                foreach ( $ancestors as $ancestor ) {
                    $ancestor = get_term( $ancestor, 'product_cat' );

                    if ( ! is_wp_error( $ancestor ) && $ancestor ) {
                        echo $before . '<a href="' . get_term_link( $ancestor ) . '">' . $ancestor->name . '</a>' . $after . $delimiter;
                    }
                }

                echo $before . '<a href="' . get_term_link( $main_term->slug, 'product_cat' ) . '">' . $main_term->name . '</a>' . $after . $delimiter;

            }

            echo $before . get_the_title() . $after;

        } elseif ( 'post' != get_post_type() ) {

            $post_type = get_post_type_object( get_post_type() );
            $slug = $post_type->rewrite;
            echo $before . '<a href="' . get_post_type_archive_link( get_post_type() ) . '">' . $post_type->labels->singular_name . '</a>' . $after . $delimiter;
            echo $before . get_the_title() . $after;

        } else {

        $cat = current( get_the_category() );
        if ( ( $parents = get_category_parents( $cat, TRUE, $after . $delimiter . $before ) ) && ! is_wp_error( $parents ) ) {
            echo $before . rtrim( $parents, $after . $delimiter . $before ) . $after . $delimiter;
        }
        echo $before . get_the_title() . $after;

        }

    } elseif ( is_404() ) {

        echo $before . __( 'Error 404', 'yiw' ) . $after;

    } elseif ( ! is_single() && ! is_page() && get_post_type() != 'post' ) {

        $post_type = get_post_type_object( get_post_type() );

        if ( $post_type ) {
            echo $before . $post_type->labels->singular_name . $after;
        }

    } elseif ( is_attachment() ) {

        $parent = get_post( $post->post_parent );
        $cat = get_the_category( $parent->ID );
        $cat = $cat[0];
        if ( ( $parents = get_category_parents( $cat, TRUE, $after . $delimiter . $before ) ) && ! is_wp_error( $parents ) ) {
            echo $before . rtrim( $parents, $after . $delimiter . $before ) . $after . $delimiter;
        }
        echo $before . '<a href="' . get_permalink( $parent ) . '">' . $parent->post_title . '</a>' . $after . $delimiter;
        echo $before . get_the_title() . $after;

    } elseif ( is_page() && !$post->post_parent ) {

        echo $before . get_the_title() . $after;

    } elseif ( is_page() && $post->post_parent ) {

        $parent_id  = $post->post_parent;
        $breadcrumbs = array();

        while ( $parent_id ) {
            $page          = get_post( $parent_id );
            $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title( $page->ID ) . '</a>';
            $parent_id  = $page->post_parent;
        }

        $breadcrumbs = array_reverse( $breadcrumbs );

        foreach ( $breadcrumbs as $crumb ) {
            echo $before . $crumb . $after . $delimiter;
        }

        echo $before . get_the_title() . $after;

    } elseif ( is_search() ) {

        echo $before . __( 'Search results for &ldquo;', 'yiw' ) . get_search_query() . '&rdquo;' . $after;

    } elseif ( is_tag() ) {

        echo $before . __( 'Posts tagged &ldquo;', 'yiw' ) . single_tag_title('', false) . '&rdquo;' . $after;

    } elseif ( is_author() ) {

        $userdata = get_userdata($author);
        echo $before . __( 'Author:', 'yiw' ) . ' ' . $userdata->display_name . $after;

    }

    if ( get_query_var( 'paged' ) )   {
        echo ' (' . __( 'Page', 'yiw' ) . ' ' . get_query_var( 'paged' ) . ')';
    }

    echo $wrap_after;

}

