<div id="portfolio-gallery" class="internal_page_items internal_page_gallery">

    <?php
    global $post;
    do_action('yit_before_portfolio_thumb_list', $post ); ?>

    <ul class="gallery-wrap image-grid group">
    <?php
    global $yiw_portfolio;

    $post_type = yiw_get_portfolio_post_type();

    $args = array(
        'post_type'      => $post_type,
        'posts_per_page' => $yiw_portfolio[$post_type]['items'] ? $yiw_portfolio[$post_type]['items'] : '-1'
    );

    if ( is_tax() )
       $args = wp_parse_args( $args, $wp_query->query );

    $gallery = new WP_Query( $args );

    $postsPerRow = (yiw_layout_page() != 'sidebar-no') ? 3 : 4;
    $i = 0;

    while( $gallery->have_posts() ) : $gallery->the_post(); ?>

        <?php
            $classes = "";
            $terms = get_the_terms( get_the_ID(), sanitize_title( $yiw_portfolio[$post_type]['tax'] ) );

            if(!empty($terms)) {
                foreach( $terms as $index=>$term) {
                    $classes .= " segment-".$index;
                }
            }
        ?>

        <?php $isFirstInRow = ( ++$i==1 | ($i % $postsPerRow) == 1 ) ? 1 : 0; ?>
        <?php $isLastInRow = ( ($i % $postsPerRow) == 0 ) ? 1 : 0; ?>

        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); ?>
        <li data-id="id-<?php echo $i; ?>" class="<?php if(!empty($terms)) foreach ($terms as $term) { echo strtolower(preg_replace('/\s+/', '-', $term->slug)) . ' '; }  ?>">

            <div class="internal_page_item internal_page_item_gallery">
                <?php the_post_thumbnail( 'thumb_gallery', array( 'class' => 'picture' ) ) ?>
                <div class="overlay">
                    <h5><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h5>
                    <?php echo yiw_excerpt( 12 ) ?>
                    <div class="controls">
						<?php if( apply_filters( 'yiw_portfolio_filterable_show_zoom', true ) ) : ?>
                        	<a class="icon-zoom" href="<?php echo $image[0] ?>" rel="prettyPhoto" title="<?php the_title() ?>">Zoom</a>
						<?php endif; ?>
                        <?php if ( yiw_get_option( 'portfolio_details_icon' ) ) : ?>
    					<a class="icon-more" href="<?php the_permalink() ?>" title="<?php the_title() ?>"><?php _e( 'View More', 'yiw' ) ?></a>
    					<?php endif ?>
    				</div>
                </div>
            </div>

        </li>
    <?php
        endwhile;
        wp_reset_query();
    ?>
    </ul>
    <div class="clear"></div>
</div>

