<?php

class ZnPluginsConfig{

	/**
	 * Main class constructor. Will only initialise if we have a config file in '/template_helpers/plugins/config.php'
	 * @return null
	 */
	function __construct(){
		if( file_exists( THEME_BASE .'/template_helpers/plugins/config.php' ) ) {

			// Include required files
			$this->includes();

			// Init the addons pages
			add_action( 'tgmpa_register', array( &$this, 'init_plugin_installer' ) );
			//add_action( 'admin_menu', array( &$this, 'zn_remove_tgm_install_menu_item'), 9999 );

			new ZnAddons();

		}
	}

	function includes(){
		include dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';
		include dirname( __FILE__ ) . '/class-addons.php';
	}

	/**
	 * Inits the TGM class with our config
	 * @return null
	 */
	function init_plugin_installer(){

	    $config = array(
	      'domain'           => 'zn_framework',
	      'default_path'     => 'tgmpa-install-plugins',
	      'parent_slug'  => 'themes.php',
	      'menu'             => 'install-required-plugins',
	      'has_notices'      => true,
	      'dismissable'      => true,
	      'dismiss_msg'      => '',
	      'is_automatic'     => true,
	      'message'          => '',
	      'strings'          => array(
	        'page_title'                      => __( 'Install Required Plugins', 'zn_framework' ),
	        'menu_title'                      => __( 'Install Plugins', 'zn_framework' ),
	        'installing'                      => __( 'Installing Plugin: %s', 'zn_framework' ),
	        'oops'                            => __( 'Something went wrong with the plugin API.', 'zn_framework' ),
	        'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'zn_framework' ),
	        'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'zn_framework' ),
	        'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'zn_framework' ),
	        'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'zn_framework' ),
	        'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'zn_framework' ),
	        'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'zn_framework' ),
	        'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'zn_framework' ),
	        'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'zn_framework' ),
	        'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'zn_framework' ),
	        'activate_link'                   => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'zn_framework' ),
	        'return'                          => __( 'Return to Required Plugins Installer', 'zn_framework' ),
	        'plugin_activated'                => __( 'Plugin activated successfully.', 'zn_framework' ),
	        'complete'                        => __( 'All plugins installed and activated successfully. %s', 'zn_framework' ),
	        'nag_type'                        => 'updated'
	      )
	    );

		include THEME_BASE .'/template_helpers/plugins/config.php';
		tgmpa( (array)$plugins, $config );
	}

	function zn_remove_tgm_install_menu_item() {
		remove_submenu_page( 'themes.php', 'install-required-plugins' );
	}

}


new ZnPluginsConfig;