<?php
/**
 * Loop Add to Cart
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $post, $woocommerce_loop;

/* FIX WOO 2.1 */
if ( ! isset( $product ) ) {
    global $product;

    if ( empty( $product ) ) {
        $product = wc_setup_product_data( $post );
    }
}

if ( isset( $woocommerce_loop['style'] ) )
    $style = $woocommerce_loop['style'];
else
    $style = yiw_get_option( 'shop_products_style', 'ribbon' );

if( $product->get_price() === '' && $product->product_type!=='external' || ! $product->is_purchasable()) return;
?>



<div class="buttons">
<?php if ( $style == 'traditional' ) : ?><a href="<?php echo get_permalink($product->id); ?>" class="details"><?php echo yiw_get_option( 'shop_button_details_label' ) ?></a><?php endif; ?>
<?php echo apply_filters( 'woocommerce_loop_add_to_cart_link',
    sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" class="add-to-cart button %s product_type_%s">%s</a>',
        esc_url( $product->add_to_cart_url() ),
        esc_attr( $product->id ),
        esc_attr( $product->get_sku() ),
        $product->is_purchasable() ? 'add_to_cart_button' : '',
        esc_attr( $product->product_type ),
        esc_html( $product->add_to_cart_text() )
    ),
    $product );
?></div>